/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.outconn;

import com.ibm.hwmca.base.rsf.conndata.DunDialInfo;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DialConfigData
implements Persistable {
    private static final String TRACE_MASKT = "XRCSDCDT";
    private static final String TRACE_MASKF = "XRCSDCDF";
    private static final String TRACE_MASKD = "XRCSDCDD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-DialData");
    private static final String PERSISTENCE_NAME = "com.ibm.hwmca.fw.rcs.outconn.DialConfigData";
    private static DialConfigData dialConfigData = null;
    private boolean allowDial = false;
    private List phoneInfo;
    public static final int MAX_PHONE_NUMBERS = 5;

    private DialConfigData() {
        Trace.trace(TRACE_MASKT, "<> DialConfigData()");
    }

    protected DialConfigData(PersistentData data) throws PersistenceException {
        Persistent persistent = (Persistent)data;
        int version = persistent.version;
        this.allowDial = persistent.allowDial;
        this.phoneInfo = persistent.phoneInfo;
    }

    public PersistentData getPersistentData() {
        Persistent persistent = new Persistent();
        persistent.version = 1;
        persistent.allowDial = this.allowDial;
        persistent.phoneInfo = this.phoneInfo;
        return persistent;
    }

    public boolean isUpgradeData() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persist() {
        Trace.trace(TRACE_MASKT, "-> persist()");
        DialConfigData dialConfigData = this;
        synchronized (dialConfigData) {
            try {
                PersistenceManager.getPersistenceManager().write(PERSISTENCE_NAME, this);
            }
            catch (PersistenceException pe) {
                Trace.trace(TRACE_MASKF, "Unable to persist: " + pe.getMessage());
            }
        }
        Trace.trace(TRACE_MASKT, "<- persist()");
    }

    public static synchronized DialConfigData getDialConfigData() {
        Trace.trace(TRACE_MASKT, "-> getDialConfigData()");
        if (dialConfigData == null) {
            PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
            if (persMgr.contains(PERSISTENCE_NAME)) {
                try {
                    dialConfigData = (DialConfigData)persMgr.read(PERSISTENCE_NAME);
                }
                catch (PersistenceException pe) {
                    String desc = "Exception restoring persistent data:\n" + DialConfigData.getStackTrace(pe);
                    Trace.trace(TRACE_MASKF, desc);
                    dialConfigData = new DialConfigData();
                }
            } else {
                String desc = "Persistent data com.ibm.hwmca.fw.rcs.outconn.DialConfigData unavailable";
                Trace.trace(TRACE_MASKF, desc);
                dialConfigData = new DialConfigData();
            }
        }
        Trace.trace(TRACE_MASKT, "<- getDialConfigData()");
        return dialConfigData;
    }

    public boolean isAllowDial() {
        return this.allowDial;
    }

    void setAllowDial(boolean value) {
        this.allowDial = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPhoneInfo() {
        DialConfigData dialConfigData = this;
        synchronized (dialConfigData) {
            if (this.phoneInfo == null) {
                return new ArrayList(5);
            }
            ArrayList<Object> copy = new ArrayList<Object>();
            Iterator iterator = this.phoneInfo.iterator();
            while (iterator.hasNext()) {
                copy.add(((DunDialInfo)iterator.next()).clone());
            }
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPhoneInfo(List phoneInfo) {
        DialConfigData dialConfigData = this;
        synchronized (dialConfigData) {
            ArrayList<Object> copy = new ArrayList<Object>(phoneInfo.size());
            Iterator iterator = phoneInfo.iterator();
            while (iterator.hasNext()) {
                copy.add(((DunDialInfo)iterator.next()).clone());
            }
            this.phoneInfo = copy;
        }
    }

    private static String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        throwable.printStackTrace(new PrintStream(baos));
        return baos.toString();
    }

    private static class Persistent
    implements PersistentData {
        private static final long serialVersionUID = -8797285636559185683L;
        int version;
        boolean allowDial;
        List phoneInfo;

        private Persistent() {
        }
    }
}

